# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 1
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR1_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmonious_reciprocator(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial phase: Build trust through unconditional cooperation
    if len(my_history) < 3:
        return "C"  # Optimistic start for mutual benefit
    
    # Middle phase: Fair but slightly unpredictable reciprocity
    if len(my_history) < 7:
        last_opp_move = opp_history[-1] if opp_history else "C"
        if last_opp_move == "C":
            return "C" if random.random() < 0.7 else "D"  # Mostly cooperate but sometimes defect
        else:
            return "D" if random.random() < 0.9 else "C"  # Mostly defect but sometimes forgive
    
    # Final phase: Strategic defection for maximum payoff
    return "D"  # Late-game cooperation is suboptimal